(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     93209,       1875]
NotebookOptionsPosition[     90180,       1772]
NotebookOutlinePosition[     90789,       1794]
CellTagsIndexPosition[     90746,       1791]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "\n",
 StyleBox["Z , finite length transmissive diffusion",
  FontFamily->"Arial",
  FontSize->20]
}], "Title",
 CellChangeTimes->{
  3.475865912414785*^9, {3.475865943298551*^9, 3.475865955268236*^9}, {
   3.4758660429022484`*^9, 3.475866079428337*^9}, {3.475866316276884*^9, 
   3.4758663189490376`*^9}, {3.4899180970833187`*^9, 
   3.4899181046177497`*^9}, {3.521476712575059*^9, 3.5214767156602354`*^9}, {
   3.5214771897083497`*^9, 3.521477193004538*^9}, {3.5218873523293095`*^9, 
   3.5218873564375443`*^9}, {3.570533035842108*^9, 3.5705330403803673`*^9}, 
   3.5705382339774246`*^9, {3.570553977298891*^9, 3.570553984193285*^9}, {
   3.570796493918581*^9, 3.570796494859635*^9}, {3.570806877226472*^9, 
   3.570806895420513*^9}, {3.570815442413373*^9, 3.5708154428613987`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Off", "[", 
    RowBox[{"General", "::", "spell"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"Names", "[", "\"\<Global`*\>\"", "]"}], "\[IndentingNewLine]", 
   RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], "\[IndentingNewLine]", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.4899223475414314`*^9, 3.489922372043833*^9}, {
  3.489922422316708*^9, 3.4899225446377044`*^9}, {3.4899231471981688`*^9, 
  3.489923148842263*^9}, {3.5218889390790663`*^9, 3.521888942727275*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Cdl\"\>", ",", "\<\"Co\"\>", ",", "\<\"Dox\"\>", 
   ",", "\<\"F\"\>", ",", "\<\"l\"\>", ",", "\<\"lom\"\>", ",", "\<\"lZM\"\>",
    ",", "\<\"R\"\>", ",", "\<\"Rct\"\>", ",", "\<\"res\"\>", 
   ",", "\<\"Rs\"\>", ",", "\<\"T\"\>", ",", "\<\"Z\"\>", ",", "\<\"Z1\"\>", 
   ",", "\<\"Z2\"\>", ",", "\<\"Zf\"\>", ",", "\<\"ZM\"\>", ",", "\<\"Zw\"\>",
    ",", "\<\"\[Sigma]\"\>", ",", "\<\"\[CurlyPhi]\"\>", 
   ",", "\<\"\[Omega]\"\>", ",", "\<\"\[AliasDelimiter]\"\>"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.4899224480931826`*^9, 3.4899224680093217`*^9}, {
   3.4899225132789106`*^9, 3.489922572867319*^9}, 3.4899227588979597`*^9, 
   3.4899229525470357`*^9, {3.489923150031331*^9, 3.4899231591338515`*^9}, 
   3.4899232103387804`*^9, {3.4899232425756245`*^9, 3.489923428631266*^9}, 
   3.4899235748226275`*^9, 3.489924077427375*^9, 3.4899241356177034`*^9, 
   3.4899242249058104`*^9, {3.4899242571656556`*^9, 3.4899242784588737`*^9}, 
   3.489924406675207*^9, 3.489924454993971*^9, 3.489924529655241*^9, 
   3.4899245705055776`*^9, 3.489924620959463*^9, 3.5214767197844715`*^9, 
   3.521482241373288*^9, 3.5218881575273647`*^9, 3.5218884336581583`*^9, 
   3.521888592062218*^9, 3.521888625525132*^9, 3.5218889436613283`*^9, 
   3.521889196707802*^9, 3.521889326388219*^9, 3.5218896353968935`*^9, 
   3.5218899920282917`*^9, 3.5218901311722507`*^9, 3.52189052996806*^9, 
   3.5218906339220057`*^9, 3.5218909004972534`*^9, 3.5218923925335927`*^9, 
   3.5218924780914865`*^9, 3.52189263061121*^9, 3.521893227968377*^9, 
   3.521902173010004*^9, 3.521904360150101*^9, 3.521905128757063*^9, 
   3.52191141682472*^9, 3.570533733413007*^9, 3.570533910188118*^9, 
   3.57053934340388*^9, 3.570555127082655*^9, 3.5705553201646986`*^9, 
   3.5705555073474045`*^9, 3.5705555648816957`*^9, 3.5705571982221174`*^9, 
   3.570557235474248*^9, 3.5705572710812845`*^9, 3.570557954506374*^9, {
   3.5705580936843348`*^9, 3.57055813259256*^9}, 3.5707965547220583`*^9, 
   3.5708073488754487`*^9, 3.570807449685215*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Sigma]", "=", 
  RowBox[{"R", "*", 
   RowBox[{"T", "/", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["F", "2"], "*", "Co", "*", 
      RowBox[{"Sqrt", "[", "Dox", "]"}]}], ")"}]}]}]}]], "Input",
 CellChangeTimes->{{3.4756024908337126`*^9, 3.4756025132197514`*^9}, 
   3.475602710568898*^9, 3.4756028164586835`*^9, {3.475604014994418*^9, 
   3.4756040188336377`*^9}, {3.4756041023064117`*^9, 3.475604103042454*^9}, 
   3.4756042857619047`*^9, {3.4758607424280787`*^9, 3.4758607461322904`*^9}, {
   3.4758653363428354`*^9, 3.4758654700724845`*^9}, {3.4758656911581297`*^9, 
   3.475865692438203*^9}, {3.4758657258471136`*^9, 3.475865727415203*^9}, {
   3.4758660945682034`*^9, 3.4758662093987713`*^9}, 3.4758662524252324`*^9, 
   3.4758663224082355`*^9, {3.4758664993513556`*^9, 3.475866500230406*^9}, {
   3.4758665335913143`*^9, 3.47586653421535*^9}, {3.4759198606664486`*^9, 
   3.4759198680258694`*^9}, {3.4899183954853864`*^9, 
   3.4899186045743456`*^9}, {3.4899186811347246`*^9, 3.4899186819507713`*^9}, 
   3.48991949963054*^9, 3.489920529485444*^9, 3.4899208179169416`*^9, 
   3.4899211413724422`*^9, {3.4899227490373955`*^9, 3.4899227507164917`*^9}, {
   3.4899234830853806`*^9, 3.4899234915648656`*^9}, {3.5214767369024506`*^9, 
   3.5214767910695486`*^9}, {3.5218874144458623`*^9, 3.521887421799283*^9}, {
   3.521888146758748*^9, 3.5218881523740697`*^9}, {3.5705330475077753`*^9, 
   3.5705331045800395`*^9}, 3.5705337217633405`*^9, {3.570533914131343*^9, 
   3.5705339276821184`*^9}, {3.5705383096987553`*^9, 3.570538399684902*^9}, {
   3.570538455217078*^9, 3.5705385242120247`*^9}, {3.5705385781811113`*^9, 
   3.5705386130431056`*^9}, {3.5705386973959303`*^9, 
   3.5705388328526783`*^9}, {3.5705388686457253`*^9, 
   3.5705388937151594`*^9}, {3.5705539935738215`*^9, 3.5705540484529605`*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{"R", " ", "T"}], 
  RowBox[{"Co", " ", 
   SqrtBox["Dox"], " ", 
   SuperscriptBox["F", "2"]}]]], "Output",
 CellChangeTimes->{
  3.5705388964243145`*^9, 3.5705393435168867`*^9, 3.5705540511101127`*^9, 
   3.570555127196661*^9, 3.5705553203117065`*^9, 3.570555514380807*^9, 
   3.5705555650777063`*^9, 3.5705571983761263`*^9, 3.570557235591254*^9, 
   3.5705572711862907`*^9, 3.5705579546343813`*^9, {3.5705580938113422`*^9, 
   3.5705581327385683`*^9}, 3.5707965657976923`*^9, 3.5708073489944553`*^9, 
   3.570807449798221*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Zw", "=", 
  RowBox[{"\[Sigma]", "*", 
   RowBox[{
    RowBox[{"Tanh", "[", 
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"\[ImaginaryI]", "*", 
        RowBox[{"\[Omega]", "/", "Dox"}]}], "]"}], "*", "l"}], "]"}], "/", 
    RowBox[{"Sqrt", "[", 
     RowBox[{"\[ImaginaryI]", "*", "\[Omega]"}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.5705392072310915`*^9, 3.5705392132664366`*^9}, {
  3.5705540591705737`*^9, 3.5705543167563066`*^9}, {3.570555519555103*^9, 
  3.570555522548274*^9}, {3.570796514971785*^9, 3.570796546575593*^9}, {
  3.5708069943391705`*^9, 3.5708070958879786`*^9}, {3.5708071281578245`*^9, 
  3.5708071292618876`*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{"R", " ", "T", " ", 
   RowBox[{"Tanh", "[", 
    RowBox[{"l", " ", 
     SqrtBox[
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}], "Dox"]]}], "]"}]}], 
  RowBox[{"Co", " ", 
   SqrtBox["Dox"], " ", 
   SuperscriptBox["F", "2"], " ", 
   SqrtBox[
    RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}]]}]]], "Output",
 CellChangeTimes->{
  3.5705392149565334`*^9, 3.570539343543888*^9, 3.5705542143624496`*^9, {
   3.5705542553907967`*^9, 3.570554278495118*^9}, 3.5705543199654903`*^9, 
   3.570555127222663*^9, 3.57055532036771*^9, 3.5705555235353303`*^9, 
   3.57055556513371*^9, 3.5705571984211283`*^9, 3.570557235619256*^9, 
   3.5705572712172923`*^9, 3.570557954669383*^9, {3.570558093856344*^9, 
   3.570558132799572*^9}, 3.570796574837209*^9, {3.570807106310575*^9, 
   3.570807131521017*^9}, 3.5708073490324583`*^9, 3.5708074498372235`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Zf", "=", 
  RowBox[{"Rct", "+", "Zw"}]}]], "Input",
 CellChangeTimes->{{3.5705543548144836`*^9, 3.5705543616518745`*^9}}],

Cell[BoxData[
 RowBox[{"Rct", "+", 
  FractionBox[
   RowBox[{"R", " ", "T", " ", 
    RowBox[{"Tanh", "[", 
     RowBox[{"l", " ", 
      SqrtBox[
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}], "Dox"]]}], "]"}]}], 
   RowBox[{"Co", " ", 
    SqrtBox["Dox"], " ", 
    SuperscriptBox["F", "2"], " ", 
    SqrtBox[
     RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}]]}]]}]], "Output",
 CellChangeTimes->{
  3.570554363002952*^9, 3.5705551272456636`*^9, 3.5705553204257135`*^9, 
   3.57055552685052*^9, 3.5705555651917133`*^9, 3.5705571984721317`*^9, 
   3.5705572356532583`*^9, 3.570557271260295*^9, 3.570557954715386*^9, {
   3.5705580938923464`*^9, 3.570558132861575*^9}, 3.570796595635399*^9, 
   3.5708071463708663`*^9, 3.57080734907146*^9, 3.5708074498762255`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Z", "=", 
  RowBox[{"Rs", "+", 
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"1", "/", "Zf"}], "+", 
      RowBox[{"\[ImaginaryI]", "*", "\[Omega]", "*", "Cdl"}]}], 
     ")"}]}]}]}]], "Input",
 CellChangeTimes->{{3.570554375573671*^9, 3.5705544213962917`*^9}}],

Cell[BoxData[
 RowBox[{"Rs", "+", 
  FractionBox["1", 
   RowBox[{
    RowBox[{"\[ImaginaryI]", " ", "Cdl", " ", "\[Omega]"}], "+", 
    FractionBox["1", 
     RowBox[{"Rct", "+", 
      FractionBox[
       RowBox[{"R", " ", "T", " ", 
        RowBox[{"Tanh", "[", 
         RowBox[{"l", " ", 
          SqrtBox[
           FractionBox[
            RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}], "Dox"]]}], "]"}]}], 
       RowBox[{"Co", " ", 
        SqrtBox["Dox"], " ", 
        SuperscriptBox["F", "2"], " ", 
        SqrtBox[
         RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}]]}]]}]]}]]}]], "Output",
 CellChangeTimes->{3.570796818595151*^9, 3.5708071546633406`*^9, 
  3.570807349107462*^9, 3.5708074499162283`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["\[AliasDelimiter]"], "Input",
 CellChangeTimes->{3.5707967567316127`*^9}],

Cell[BoxData["\[AliasDelimiter]"], "Output",
 CellChangeTimes->{3.5708073491474648`*^9, 3.57080744995623*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Z1", "=", 
  RowBox[{"Re", "[", "Z", "]"}]}]], "Input",
 CellChangeTimes->{{3.5705544366851664`*^9, 3.570554446386721*^9}}],

Cell[BoxData[
 RowBox[{"Re", "[", 
  RowBox[{"Rs", "+", 
   FractionBox["1", 
    RowBox[{
     RowBox[{"\[ImaginaryI]", " ", "Cdl", " ", "\[Omega]"}], "+", 
     FractionBox["1", 
      RowBox[{"Rct", "+", 
       FractionBox[
        RowBox[{"R", " ", "T", " ", 
         RowBox[{"Tanh", "[", 
          RowBox[{"l", " ", 
           SqrtBox[
            FractionBox[
             RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}], "Dox"]]}], "]"}]}], 
        RowBox[{"Co", " ", 
         SqrtBox["Dox"], " ", 
         SuperscriptBox["F", "2"], " ", 
         SqrtBox[
          RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}]]}]]}]]}]]}], 
  "]"}]], "Output",
 CellChangeTimes->{
  3.570554447671795*^9, 3.5705551273266687`*^9, 3.57055532054072*^9, 
   3.5705555653087196`*^9, 3.5705568274239087`*^9, 3.5705571985761375`*^9, 
   3.570557235721262*^9, 3.570557271341299*^9, 3.5705579548053913`*^9, {
   3.5705580939923525`*^9, 3.570558132978582*^9}, 3.5707968342810483`*^9, 
   3.5708071803678107`*^9, 3.570807349181466*^9, 3.5708074500122337`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Z2", "=", 
  RowBox[{"Im", "[", "Z", "]"}]}]], "Input",
 CellChangeTimes->{{3.570554449777915*^9, 3.5705544568673205`*^9}}],

Cell[BoxData[
 RowBox[{"Im", "[", 
  RowBox[{"Rs", "+", 
   FractionBox["1", 
    RowBox[{
     RowBox[{"\[ImaginaryI]", " ", "Cdl", " ", "\[Omega]"}], "+", 
     FractionBox["1", 
      RowBox[{"Rct", "+", 
       FractionBox[
        RowBox[{"R", " ", "T", " ", 
         RowBox[{"Tanh", "[", 
          RowBox[{"l", " ", 
           SqrtBox[
            FractionBox[
             RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}], "Dox"]]}], "]"}]}], 
        RowBox[{"Co", " ", 
         SqrtBox["Dox"], " ", 
         SuperscriptBox["F", "2"], " ", 
         SqrtBox[
          RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}]]}]]}]]}]]}], 
  "]"}]], "Output",
 CellChangeTimes->{
  3.5705544587714295`*^9, 3.570555127376672*^9, 3.5705553206007233`*^9, 
   3.570555565362723*^9, 3.5705568312251263`*^9, 3.5705571986381407`*^9, 
   3.570557235754264*^9, 3.5705572713763013`*^9, 3.5705579548483934`*^9, {
   3.5705580940273542`*^9, 3.5705581330375853`*^9}, 3.5707968400143766`*^9, 
   3.570807186182143*^9, 3.570807349222469*^9, 3.570807450058236*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"ZM", "=", 
  RowBox[{"Sqrt", "[", 
   RowBox[{
    RowBox[{"Z1", "^", "2"}], "+", 
    RowBox[{"Z2", "^", "2"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"lZM", "=", 
  RowBox[{"Log10", "[", "ZM", "]"}]}]}], "Input",
 CellChangeTimes->{{3.5705544727082267`*^9, 3.5705544926593676`*^9}, {
  3.570554806084295*^9, 3.5705548115736084`*^9}}],

Cell[BoxData[
 SqrtBox[
  RowBox[{
   SuperscriptBox[
    RowBox[{"Im", "[", 
     RowBox[{"Rs", "+", 
      FractionBox["1", 
       RowBox[{
        RowBox[{"\[ImaginaryI]", " ", "Cdl", " ", "\[Omega]"}], "+", 
        FractionBox["1", 
         RowBox[{"Rct", "+", 
          FractionBox[
           RowBox[{"R", " ", "T", " ", 
            RowBox[{"Tanh", "[", 
             RowBox[{"l", " ", 
              SqrtBox[
               FractionBox[
                RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}], "Dox"]]}], 
             "]"}]}], 
           RowBox[{"Co", " ", 
            SqrtBox["Dox"], " ", 
            SuperscriptBox["F", "2"], " ", 
            SqrtBox[
             RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}]]}]]}]]}]]}], "]"}], 
    "2"], "+", 
   SuperscriptBox[
    RowBox[{"Re", "[", 
     RowBox[{"Rs", "+", 
      FractionBox["1", 
       RowBox[{
        RowBox[{"\[ImaginaryI]", " ", "Cdl", " ", "\[Omega]"}], "+", 
        FractionBox["1", 
         RowBox[{"Rct", "+", 
          FractionBox[
           RowBox[{"R", " ", "T", " ", 
            RowBox[{"Tanh", "[", 
             RowBox[{"l", " ", 
              SqrtBox[
               FractionBox[
                RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}], "Dox"]]}], 
             "]"}]}], 
           RowBox[{"Co", " ", 
            SqrtBox["Dox"], " ", 
            SuperscriptBox["F", "2"], " ", 
            SqrtBox[
             RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}]]}]]}]]}]]}], "]"}], 
    "2"]}]]], "Output",
 CellChangeTimes->{
  3.570554493429412*^9, 3.5705548131526985`*^9, 3.5705551274066734`*^9, 
   3.570555320663727*^9, 3.5705555654227266`*^9, 3.570557198701144*^9, 
   3.5705572357882657`*^9, 3.570557271410303*^9, 3.5705579548883963`*^9, {
   3.5705580940633564`*^9, 3.5705581330955887`*^9}, 3.570796842648527*^9, 
   3.570807190127369*^9, 3.570807349278472*^9, 3.5708074501202397`*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{"Log", "[", 
   SqrtBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"Im", "[", 
       RowBox[{"Rs", "+", 
        FractionBox["1", 
         RowBox[{
          RowBox[{"\[ImaginaryI]", " ", "Cdl", " ", "\[Omega]"}], "+", 
          FractionBox["1", 
           RowBox[{"Rct", "+", 
            FractionBox[
             RowBox[{"R", " ", "T", " ", 
              RowBox[{"Tanh", "[", 
               RowBox[{"l", " ", 
                SqrtBox[
                 FractionBox[
                  RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}], "Dox"]]}], 
               "]"}]}], 
             RowBox[{"Co", " ", 
              SqrtBox["Dox"], " ", 
              SuperscriptBox["F", "2"], " ", 
              SqrtBox[
               RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}]]}]]}]]}]]}], "]"}], 
      "2"], "+", 
     SuperscriptBox[
      RowBox[{"Re", "[", 
       RowBox[{"Rs", "+", 
        FractionBox["1", 
         RowBox[{
          RowBox[{"\[ImaginaryI]", " ", "Cdl", " ", "\[Omega]"}], "+", 
          FractionBox["1", 
           RowBox[{"Rct", "+", 
            FractionBox[
             RowBox[{"R", " ", "T", " ", 
              RowBox[{"Tanh", "[", 
               RowBox[{"l", " ", 
                SqrtBox[
                 FractionBox[
                  RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}], "Dox"]]}], 
               "]"}]}], 
             RowBox[{"Co", " ", 
              SqrtBox["Dox"], " ", 
              SuperscriptBox["F", "2"], " ", 
              SqrtBox[
               RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}]]}]]}]]}]]}], "]"}], 
      "2"]}]], "]"}], 
  RowBox[{"Log", "[", "10", "]"}]]], "Output",
 CellChangeTimes->{
  3.570554493429412*^9, 3.5705548131526985`*^9, 3.5705551274066734`*^9, 
   3.570555320663727*^9, 3.5705555654227266`*^9, 3.570557198701144*^9, 
   3.5705572357882657`*^9, 3.570557271410303*^9, 3.5705579548883963`*^9, {
   3.5705580940633564`*^9, 3.5705581330955887`*^9}, 3.570796842648527*^9, 
   3.570807190127369*^9, 3.570807349278472*^9, 3.57080745012424*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Omega]", "=", 
  RowBox[{"10", "^", "lom"}]}]], "Input",
 CellChangeTimes->{{3.5705545122914906`*^9, 3.5705545204389567`*^9}}],

Cell[BoxData[
 SuperscriptBox["10", "lom"]], "Output",
 CellChangeTimes->{
  3.570554521526019*^9, 3.570555127457676*^9, 3.5705553207367315`*^9, 
   3.570555565496731*^9, 3.570557198785149*^9, 3.570557235825268*^9, 
   3.5705572714463053`*^9, 3.570557954939399*^9, {3.5705580941353607`*^9, 
   3.570558133168593*^9}, 3.570796845715702*^9, 3.570807199134884*^9, 
   3.5708073493374753`*^9, 3.5708074501822433`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Rs", "=", "10"}], "\[IndentingNewLine]", 
 RowBox[{"Rct", "=", "50"}], "\[IndentingNewLine]", 
 RowBox[{"Cdl", "=", 
  RowBox[{"20", "*", 
   RowBox[{"10", "^", 
    RowBox[{"-", "6"}]}]}]}], "\[IndentingNewLine]", 
 RowBox[{"Dox", "=", 
  RowBox[{"1", "*", 
   RowBox[{"10", "^", 
    RowBox[{"-", "5"}]}]}]}], "\[IndentingNewLine]", 
 RowBox[{"Co", "=", 
  RowBox[{"2", "*", 
   RowBox[{"10", "^", 
    RowBox[{"-", "6"}]}]}]}], "\[IndentingNewLine]", 
 RowBox[{"l", "=", "0.01"}], "\[IndentingNewLine]", 
 RowBox[{"F", "=", "96485"}], "\[IndentingNewLine]", 
 RowBox[{"T", "=", "298.15"}], "\[IndentingNewLine]", 
 RowBox[{"R", "=", "8.31447"}]}], "Input",
 CellChangeTimes->{{3.5218874289926944`*^9, 3.521887476006384*^9}, {
   3.5218880815430183`*^9, 3.5218880856382523`*^9}, {3.5705331185628395`*^9, 
   3.570533164322457*^9}, {3.5705389117301893`*^9, 3.570538957625815*^9}, {
   3.5705545315715933`*^9, 3.5705545321316257`*^9}, {3.5705546440840287`*^9, 
   3.570554744162753*^9}, {3.570555291317048*^9, 3.5705552918600793`*^9}, {
   3.570558088948064*^9, 3.57055814814845*^9}, 3.5707968842859087`*^9, {
   3.570807239695204*^9, 3.57080727179004*^9}}],

Cell[BoxData["10"], "Output",
 CellChangeTimes->{{3.5705545981264*^9, 3.5705546126802325`*^9}, 
   3.570554720383393*^9, 3.5705547508661366`*^9, 3.5705551274966784`*^9, 
   3.5705553207967343`*^9, 3.5705555655787354`*^9, 3.570557198864154*^9, 
   3.57055723585927*^9, 3.5705572714863076`*^9, {3.5705579426746974`*^9, 
   3.570557954979401*^9}, {3.570558094196364*^9, 3.570558133229596*^9}, 
   3.570796888436146*^9, 3.5708072032181177`*^9, 3.570807276028282*^9, 
   3.5708073493894787`*^9, 3.5708074502422466`*^9}],

Cell[BoxData["50"], "Output",
 CellChangeTimes->{{3.5705545981264*^9, 3.5705546126802325`*^9}, 
   3.570554720383393*^9, 3.5705547508661366`*^9, 3.5705551274966784`*^9, 
   3.5705553207967343`*^9, 3.5705555655787354`*^9, 3.570557198864154*^9, 
   3.57055723585927*^9, 3.5705572714863076`*^9, {3.5705579426746974`*^9, 
   3.570557954979401*^9}, {3.570558094196364*^9, 3.570558133229596*^9}, 
   3.570796888436146*^9, 3.5708072032181177`*^9, 3.570807276028282*^9, 
   3.5708073493894787`*^9, 3.5708074502462473`*^9}],

Cell[BoxData[
 FractionBox["1", "50000"]], "Output",
 CellChangeTimes->{{3.5705545981264*^9, 3.5705546126802325`*^9}, 
   3.570554720383393*^9, 3.5705547508661366`*^9, 3.5705551274966784`*^9, 
   3.5705553207967343`*^9, 3.5705555655787354`*^9, 3.570557198864154*^9, 
   3.57055723585927*^9, 3.5705572714863076`*^9, {3.5705579426746974`*^9, 
   3.570557954979401*^9}, {3.570558094196364*^9, 3.570558133229596*^9}, 
   3.570796888436146*^9, 3.5708072032181177`*^9, 3.570807276028282*^9, 
   3.5708073493894787`*^9, 3.5708074502492476`*^9}],

Cell[BoxData[
 FractionBox["1", "100000"]], "Output",
 CellChangeTimes->{{3.5705545981264*^9, 3.5705546126802325`*^9}, 
   3.570554720383393*^9, 3.5705547508661366`*^9, 3.5705551274966784`*^9, 
   3.5705553207967343`*^9, 3.5705555655787354`*^9, 3.570557198864154*^9, 
   3.57055723585927*^9, 3.5705572714863076`*^9, {3.5705579426746974`*^9, 
   3.570557954979401*^9}, {3.570558094196364*^9, 3.570558133229596*^9}, 
   3.570796888436146*^9, 3.5708072032181177`*^9, 3.570807276028282*^9, 
   3.5708073493894787`*^9, 3.5708074502532473`*^9}],

Cell[BoxData[
 FractionBox["1", "500000"]], "Output",
 CellChangeTimes->{{3.5705545981264*^9, 3.5705546126802325`*^9}, 
   3.570554720383393*^9, 3.5705547508661366`*^9, 3.5705551274966784`*^9, 
   3.5705553207967343`*^9, 3.5705555655787354`*^9, 3.570557198864154*^9, 
   3.57055723585927*^9, 3.5705572714863076`*^9, {3.5705579426746974`*^9, 
   3.570557954979401*^9}, {3.570558094196364*^9, 3.570558133229596*^9}, 
   3.570796888436146*^9, 3.5708072032181177`*^9, 3.570807276028282*^9, 
   3.5708073493894787`*^9, 3.5708074502552476`*^9}],

Cell[BoxData["0.01`"], "Output",
 CellChangeTimes->{{3.5705545981264*^9, 3.5705546126802325`*^9}, 
   3.570554720383393*^9, 3.5705547508661366`*^9, 3.5705551274966784`*^9, 
   3.5705553207967343`*^9, 3.5705555655787354`*^9, 3.570557198864154*^9, 
   3.57055723585927*^9, 3.5705572714863076`*^9, {3.5705579426746974`*^9, 
   3.570557954979401*^9}, {3.570558094196364*^9, 3.570558133229596*^9}, 
   3.570796888436146*^9, 3.5708072032181177`*^9, 3.570807276028282*^9, 
   3.5708073493894787`*^9, 3.5708074502582474`*^9}],

Cell[BoxData["96485"], "Output",
 CellChangeTimes->{{3.5705545981264*^9, 3.5705546126802325`*^9}, 
   3.570554720383393*^9, 3.5705547508661366`*^9, 3.5705551274966784`*^9, 
   3.5705553207967343`*^9, 3.5705555655787354`*^9, 3.570557198864154*^9, 
   3.57055723585927*^9, 3.5705572714863076`*^9, {3.5705579426746974`*^9, 
   3.570557954979401*^9}, {3.570558094196364*^9, 3.570558133229596*^9}, 
   3.570796888436146*^9, 3.5708072032181177`*^9, 3.570807276028282*^9, 
   3.5708073493894787`*^9, 3.5708074502612476`*^9}],

Cell[BoxData["298.15`"], "Output",
 CellChangeTimes->{{3.5705545981264*^9, 3.5705546126802325`*^9}, 
   3.570554720383393*^9, 3.5705547508661366`*^9, 3.5705551274966784`*^9, 
   3.5705553207967343`*^9, 3.5705555655787354`*^9, 3.570557198864154*^9, 
   3.57055723585927*^9, 3.5705572714863076`*^9, {3.5705579426746974`*^9, 
   3.570557954979401*^9}, {3.570558094196364*^9, 3.570558133229596*^9}, 
   3.570796888436146*^9, 3.5708072032181177`*^9, 3.570807276028282*^9, 
   3.5708073493894787`*^9, 3.570807450264248*^9}],

Cell[BoxData["8.31447`"], "Output",
 CellChangeTimes->{{3.5705545981264*^9, 3.5705546126802325`*^9}, 
   3.570554720383393*^9, 3.5705547508661366`*^9, 3.5705551274966784`*^9, 
   3.5705553207967343`*^9, 3.5705555655787354`*^9, 3.570557198864154*^9, 
   3.57055723585927*^9, 3.5705572714863076`*^9, {3.5705579426746974`*^9, 
   3.570557954979401*^9}, {3.570558094196364*^9, 3.570558133229596*^9}, 
   3.570796888436146*^9, 3.5708072032181177`*^9, 3.570807276028282*^9, 
   3.5708073493894787`*^9, 3.570807450268248*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Z1", ",", "Z2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"lom", ",", 
     RowBox[{"-", "3"}], ",", "6"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.4756034305039873`*^9, 3.4756034317770596`*^9}, {
   3.4756034944846463`*^9, 3.475603513969761*^9}, {3.475603551473906*^9, 
   3.475603587393961*^9}, 3.4756036488824778`*^9, {3.4756036989943438`*^9, 
   3.4756037027855606`*^9}, {3.4756039087223396`*^9, 
   3.4756039240022135`*^9}, {3.475603989492959*^9, 3.475604001249632*^9}, {
   3.475604151650234*^9, 3.4756041615057983`*^9}, {3.475604357794025*^9, 
   3.47560439371408*^9}, {3.475605209794757*^9, 3.4756052162581263`*^9}, {
   3.4756054334265475`*^9, 3.475605473281827*^9}, {3.475605514436181*^9, 
   3.4756055396506233`*^9}, 3.475865811559016*^9, 3.4758664622142315`*^9, 
   3.4899210018204603`*^9, {3.489921220908992*^9, 3.48992123574084*^9}, {
   3.5214770962080016`*^9, 3.521477119023307*^9}, {3.521888419623355*^9, 
   3.5218884200383787`*^9}, {3.521889136119336*^9, 3.521889146198913*^9}, 
   3.521905292455426*^9, 3.521911388120078*^9, {3.5705338870747957`*^9, 
   3.570533898082425*^9}, {3.5705339800831156`*^9, 3.570534005494569*^9}, 
   3.570539142100366*^9, {3.570554838147128*^9, 3.5705548545010643`*^9}, 
   3.5705548849028025`*^9, {3.570796901071869*^9, 3.5707969015338955`*^9}, {
   3.5708073179186783`*^9, 3.570807321903906*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13c8VW8YAHArIxRJimtfhOx5hR5bLu4lI4psIiNESZQkadFQoSIlDVQ2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     "]]}},
  Axes->True,
  AxesOrigin->{0, 0},
  Method->{},
  PlotRange->{{0., 193.14166544086243`}, {-55.617601169220855`, 0.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.5705572359982777`*^9, 3.570557271602314*^9, 3.5705579551504107`*^9, {
   3.5705580943653736`*^9, 3.5705581333856053`*^9}, {3.570796892456376*^9, 
   3.570796904154045*^9}, 3.570807208943445*^9, 3.5708072813775883`*^9, {
   3.5708073243270445`*^9, 3.57080734959549*^9}, 3.570807450351253*^9}]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.5705572046414843`*^9, 3.5705572046984873`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Re", "[", "Zf", "]"}], ",", 
     RowBox[{"Im", "[", "Zf", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"lom", ",", 
     RowBox[{"-", "4"}], ",", "6"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.570554936758769*^9, 3.57055496859659*^9}, {
  3.5707969178858304`*^9, 3.5707969214870367`*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwl13k4VF0YAHBlF5IthBQKUxKypHSIYWZsZd/HMkP2LH22QiRaKEmi7Fkq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     "]]}},
  Axes->True,
  AxesOrigin->{60., 0},
  Method->{},
  PlotRange->{{50.02977177913441, 183.14342615882703`}, {-55.55098068871669, 
   0.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.570557236051281*^9, 3.570557271666318*^9, 3.570557955226415*^9, {
   3.5705580944143763`*^9, 3.5705581334366083`*^9}, 3.570796923273138*^9, {
   3.5708073385868607`*^9, 3.5708073496454926`*^9}, 3.5708074504012556`*^9}]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.570557207026621*^9, 3.5705572070806236`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[CurlyPhi]", "=", 
  RowBox[{
   RowBox[{"ArcTan", "[", 
    RowBox[{"Z2", "/", "Z1"}], "]"}], "*", 
   RowBox[{"180", "/", "\[Pi]"}]}]}]], "Input",
 CellChangeTimes->{{3.5219007065651283`*^9, 3.5219007065841293`*^9}, {
  3.5705340884983163`*^9, 3.5705341365780663`*^9}, {3.5705342253151417`*^9, 
  3.570534229010353*^9}, {3.570535226003378*^9, 3.5705352276364717`*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{"180", " ", 
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{"Im", "[", 
      FractionBox["1", 
       RowBox[{
        RowBox[{"\[ImaginaryI]", " ", 
         SuperscriptBox["2", 
          RowBox[{
           RowBox[{"-", "4"}], "+", "lom"}]], " ", 
         SuperscriptBox["5", 
          RowBox[{
           RowBox[{"-", "5"}], "+", "lom"}]]}], "+", 
        FractionBox["1", 
         RowBox[{"50", "+", 
          FractionBox[
           RowBox[{"42.10365382785329`", " ", 
            RowBox[{"Tanh", "[", 
             RowBox[{"0.01`", " ", 
              SqrtBox[
               RowBox[{"\[ImaginaryI]", " ", 
                SuperscriptBox["10", 
                 RowBox[{"5", "+", "lom"}]]}]]}], "]"}]}], 
           SqrtBox[
            RowBox[{"\[ImaginaryI]", " ", 
             SuperscriptBox["10", "lom"]}]]]}]]}]], "]"}], 
     RowBox[{"10", "+", 
      RowBox[{"Re", "[", 
       FractionBox["1", 
        RowBox[{
         RowBox[{"\[ImaginaryI]", " ", 
          SuperscriptBox["2", 
           RowBox[{
            RowBox[{"-", "4"}], "+", "lom"}]], " ", 
          SuperscriptBox["5", 
           RowBox[{
            RowBox[{"-", "5"}], "+", "lom"}]]}], "+", 
         FractionBox["1", 
          RowBox[{"50", "+", 
           FractionBox[
            RowBox[{"42.10365382785329`", " ", 
             RowBox[{"Tanh", "[", 
              RowBox[{"0.01`", " ", 
               SqrtBox[
                RowBox[{"\[ImaginaryI]", " ", 
                 SuperscriptBox["10", 
                  RowBox[{"5", "+", "lom"}]]}]]}], "]"}]}], 
            SqrtBox[
             RowBox[{"\[ImaginaryI]", " ", 
              SuperscriptBox["10", "lom"]}]]]}]]}]], "]"}]}]], "]"}]}], 
  "\[Pi]"]], "Output",
 CellChangeTimes->{
  3.5705341416623573`*^9, 3.5705342311404753`*^9, 3.570535231352684*^9, 
   3.570539161852496*^9, 3.570539343825904*^9, 3.57055489307027*^9, 
   3.570555127712691*^9, 3.5705553209927454`*^9, 3.5705555658767524`*^9, 
   3.570557199095167*^9, 3.5705572360782824`*^9, 3.5705572716983194`*^9, 
   3.570557955257417*^9, {3.570558094444378*^9, 3.57055813346661*^9}, 
   3.5707969350128098`*^9, 3.5708073496724944`*^9, 3.5708074504282575`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"lom", ",", "\[CurlyPhi]"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"lom", ",", 
     RowBox[{"-", "4"}], ",", "6"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.4758610857867174`*^9, 3.4758610994945016`*^9}, {
   3.47586139511141*^9, 3.4758614066940727`*^9}, 3.475861522949722*^9, {
   3.475861586262343*^9, 3.475861623062448*^9}, 3.4758639548218164`*^9, {
   3.475864446741953*^9, 3.4758644503101573`*^9}, {3.4758646109663463`*^9, 
   3.4758646390459523`*^9}, {3.4758646771931343`*^9, 3.4758646914299483`*^9}, 
   3.4758665906145754`*^9, 3.4759254965058002`*^9, 3.4899212624123654`*^9, {
   3.4899227056129117`*^9, 3.4899227097861505`*^9}, 3.5214822947193394`*^9, {
   3.521888447014922*^9, 3.521888491815484*^9}, 3.521911393096363*^9, {
   3.5705341597473917`*^9, 3.5705341793945155`*^9}, 3.570555008228857*^9, 
   3.5707969433742886`*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwlm3c8lt//x+112/u2dyQl666k6yRukpURLSFl5KOSpC0lVMpOSFSolDKT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     "]]}},
  Axes->True,
  AxesOrigin->{0, 0},
  Method->{},
  PlotRange->{{-4., 6.}, {-45.788086639089386`, 0.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.570557236110284*^9, 3.570557271809326*^9, 3.5705579553724236`*^9, {
   3.570558094558385*^9, 3.570558133580617*^9}, 3.570796945274397*^9, 
   3.5708073498115025`*^9, 3.5708074505602646`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"lom", ",", "lZM"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"lom", ",", 
     RowBox[{"-", "4"}], ",", "6"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5707969728999767`*^9, 3.570797001887635*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwl2nk8VN/7APCZMWPfh7GVPSmRXVGdYxeybyklkaVCaCVakJAkopRE9rJF
i8q9IkuLLOlDipQUWcaSBoPfud+fP3i9X/fOnHue85zzPDMvCj4hTn4UEok0
g34Rf///Rxi/Er33SOROCpS4Irr7XLYQnmnle5iwhvS6apKBEG6tpB5EuM67
fACnCuHzcscDCVsUGfCd7xLEk6SKAgh3TeAGxrmC+OxR3J+wl661LzlYED+x
sf4QYd1d2KVLBoL4qw0X/QjzHtItEyAL4kfXyPkSPj4z+aLjpwD+hm/vQcLf
okvar78RwHlKkn0IP8mUnZFKF8BrG197E1ZU7uP4ekoAX5f8bj/hlMrr4rle
AvjnG437CC9ss1t/0EQAt/1Z4kXYt417q8p6Afx7QPRewh9cG61H+QTwMTLc
Q9jw+9m9D5j8eGz0xG7CIkszMdp1/LjqAqc7YZPvt+iRD/lxm/W2boTD2kyK
GnP5cfmxJFfCHzPT2l0u8eNNSYvOhLN0tdeedOHHnyRfdSDcJvO5ErPkx3/X
3rcnvEi5YMZtxI8bCD2yI7yns/PwTQV+/GB8nS1h2eBjdc8n+fDyu8FWhO1d
peyo3/nwrUcsLQmf29YwZNvDhxcUS1gQ/s4rwjPwnA9nht4xJVxQVOlOusyH
3+/W30H4U4rHH6soPrwUa9xGmPMEKeZaCB8u99vciHCAmUOhohsfbvVAdQvh
TUNTc2ZKfHj+w31ahOMTCjfxrOXDuysjNf+3Ppu9fN8z+PCWmIzNhNOj33S7
8vLhF5wwdcJsmYLqQ9O8eGnU2AbC79w8QxMwXnzr1+sKhFVWhIttn/HiJz+c
lP/ffApaBoUf8eJmmLvc//JlTtf+ZiEvvs+Lby3h29eENEqv8OJDTCBJ+Mi7
pj9v9/Dii8UdAoSbwyOVUl158QtaR/kJy8to73Gx58UTa6l8/1ufwLtvvpjw
4q7+ytyEt3GdKZnYwIt3+ylTCPObbPYXYvHgTonif88gHxr9mdM9zYNz1XrM
EsZTb3/K/MODO2RlTBOOGOSxkB/kwePU2ROEv0QNK2s18+BtlDMjhMue3Pzu
lM6D736p+ImwXZ9639UrPLhYQnM34ZnFhg/v4nlwDpEDnYS37Bh7YXGaB699
e/od4eYmw0zDfTy4TaveK8KBI+1XTrrz4HZHkjDC/NwHY2scePDV7E8vCDvb
JB3TMOXBOxZsnxD+1tlvo6jKg//irS0jHDsbYrJfgQePOFJdTHi9OHXrbWke
PGE1v4BwsMcmFYYAmh/p4F3CSwNRJN4ZbjxWwyaNMGN8be30c278bVfmccJ1
AtVlGrXc+Np5/Bhhr80WeYfLufE43v6jhO+HBV/9mcuNh0sN+RHWWqgP7Ivj
xu3kNVwJf5R29mbEcOPLir0OhE9t++XmfIobV1U+Zku4PkbI7H0QNy7PCDEl
bMvpLdtgz423qF3XJDy1fk5sxYobD739UI1w2s4EPiMTbjyqt0aFcF9yJatG
F40Xm7Dmf+tJJ3cXS3HjXMpo5ZHPy+ddSv3Bhd8yTe49jZyXls1h/JULT/n9
tIvwK2pGzPQnLvzg9o53hKmjl046veHCq16+xAknVB31F6viwtOtk4oIp5ps
tcyK5sKVjQtDCVfVaDdaneLC77W5BRLuUtkEFo5x4f7Xxw8QFuOTM/D048K5
fJqdCGd1U9evseXCWwbW6xDO9e3gzJXiwlOFzSdPITd8arvgQOfC32dL/iT8
3apxhSTAhbtkvuknrKz+eP4AiQvfP9PSSrj4b/aI0i9OvM5T+h7hinj/5qIa
Tjx/tNiacAfL28SjnBP3GVkHCDODPOu5iznxp69P6RDWtt/1ODCbE69tuCND
+LGETqHaBU48yap79CSxPsUrcRX2nLjto91nCatm9OC9Vpw4T0bFUcLXzz9Y
Iptw4vFOLV6EAzw9j7nocuKjF7ZsJyzC/3jvgiQnDj/QFk4gR7GSMxVFOfG2
ertfhEeGD3bZ8KHn8XfsIVz3UsQqZ5mG+8XHVBL2DTmqY/qdhuf67T9IuH2P
WfCRfhpu8sDNnvAWK5mSjI80PPD0iiFhAYU22d/NNNyj1lOE8OMuZd4rZTS8
maRYdxyZR//Lt08RNFxX5+ViBLG/FR/JkIJpePvXtUOEBwQT3Tb403DDYckW
wtW/DN5F7qbh+VX/XSO89+b1J/I7aPiGImtFws1xQTM7DWi47CMHGmHNMGP1
cE0avvn9j1/hyDSbqbzXijR8kFpaRricbZ0SxEXD44cuqBOWHFVou06i4QYT
L/kJX+xhcbxcoOK5Syf+hCF7lBeeFhqn4na8e4oIk70pfjUdVPxWcqUkYZfG
Z0YrN6n4W6m8wVDifD0Y7mt5nYpvOxT9mPADDvUrqclUPOZCXTJhqlnugGIM
FQ/0sTIg/Kgp/rylLxVX2xQRG0LM3xeWpnpR8c/53G6EeWmLXX1uVPzk3t8q
hH3Mjyof2UnFlS5FNwcjizY7t6RqUPEX8o/ZR5F3HBJg9q2n4t0Wrq2Egzhb
JJUUqPjrSNXrhF9ZGAbV0ql4SM4+FcLHWuQFPrM48G2TFSZHiHxtnXBSauTA
o15M2AcR9SWgKPLICw7c4fd2AcKqPAfu19Zy4OTQxLZAYr47P/61LObAl59y
A8Kb39RlHbnCgQt1rV8bgOwZFNFQG8+Bl/783elP1DdejbGVGA78FDUujvCA
9T2ja2EcuMX5baOHkFPeXhqodefAU4+uz/Mj8vGwMdeqAweuZQF3ER7hW9ps
Zc2BP7gu+M+XmK9t8PnP2zjwsv1PLAhPvnNRXlXgwMVUint8kHe1KwRZjVPw
1AN6D/cjz9dDSdoIBb8RHmxFOLdif3PDIAX/92rr931EvUi9o2jUTcHpNmEi
hLOcpfrV6yi4nkaP117k4V5hW3oCBVfeHlbiQTxv2+bFD+cpOEtQX42wQZ1d
cXIkBU9p3FzmjpyYnUzlDKHgl5tLC9yI/NzH/ZLlSsHv3OCIdSH2449V9QEl
Cq6UIvLNnqjXH2W/3FpLwWtrZ4wJf2januguQcHLpW/cs0NWLIwc6eCl4PFs
iucu5NaAfzmN02Q8Ti+x3Jo47yYnhUowMs5fmjpgRpwfAwL1fs/IuNLXC5KE
/T9sOqL4iIxXni+0NyXiWxnUml1IxlUsdtcaI3uHj5xLuULGU+5ZeO0g8pf1
dTp8D3LSVXED5LsHP+8rcSHjHNqB3PpEPWj/9HZgFxn/77LcP12ivtz/ULAT
kvFq1rcWbWRTh4bdcuvIuIbToK4Gsv7zl80usmTc91ErVZ3IJ5U6nUQJMu4Q
QOtQQxZkVwv85SHjW6ibPTYgfy663/BmkoQrXdBQV0Z+L3pPg/SbhGf8utuj
iIyfvZOtN0TCK862nVJALnS+cTy3m4T/+jVdLkvk9+qlDSeekvALbjt6JZG5
3Q9fU7hAwrcJDfDyE/W3wX/FLZKEvxP1cuEl8meT7+HkCBLeAOQyuYn6SfEy
/3eIhJ/ooXDTiPmX2y28syHhuRut0pet0PylbA5RzEl4SNjw/SXk2FjLboMd
JNz64vDDBeQgT/gwT5OE7+fJKv6LrM+pfeCUOBp/Jmj7BPKGYxrtDwVJuP5I
s8Af5DVfNhr94CLh148l9vxG5vC13Hh7bhX7MohbDyPfer4xzbJ+FZt5J9X6
Gbk1aPpAjuMqtjFKefI1cslQjQXTbBWb7Xnt3Iic6HFKzWTLKva+sb8CR7a1
WJ37KbuKqW7ps36O3KEgkKA+voKJ7dnAXYnc26ta/iJ+Bavi6o/ORH5mP54m
eGYF+7LL3DCdGL+54qT30RXMerp2NBV5b42+MdVlBdN9vKiUiPztqtlHG4UV
LO+NAjkK+beF9+Ln58vYvJKhrhdy20ulwU0Vy9jghrXSu5FLdX81RuctYy/X
LjFdkI8oBl9RvLyMlY69DbVFZi5Hyge5LWOq369VGyKzajItFphszHB9LK8Y
cp/aHjWbYTaWU5U3LIhclycrfOc/NnYraryMBzkqtaAP1rOx2apJ0qolBZKO
PDqSkMTGbn5nvviNzKX0IU1ChY2VscuMniIfIXs4l0ixsfFzoyNVyB2D3+hG
AmwslBwZWYacdXsmfd/cEnZM1m1/DrIqg5FZ8GoJg+Ru7ovIVjxe2Tr7lzBl
J+MblsgPfv3c89ppCZs/51sOkIWbg9e4WyxhZzVNSw2Qey+cu3NGfQnbdSXX
Zj1yADv/bsPSIraPmryBhnx5aizfPmsR2zo3MVNngfLzfbjvUNIiBihFYlXI
Tg/YyuExi1iQuyq9CFk6ULDwxqFFzM0h9X4acul3reKvuouYttUEbwDym55T
Dw53LmAToU0hfMgaNeSjy00L2H1ml9yqOcrntET1q08XMK/bfPdnkD3tb5dX
313A9LFUlT7ksVascuHoAnZWJJFyH5nvBWftJd4F7Jo1PVYTmXLVepZ3mYXV
lGv3ySGzDqRopUyxMAZNYlIQeYSLUZ7+kYX1S+91HjdD9ch5XdG9HBZ2INiB
mY/8TCXwp/I1Fvbn6XrVa8iVCw+Uii+yMKm4Bolo5Dt3dXPLA1hYa8qclDvy
qT+mN59rszBm8MUkGnJI/aX/dqxjYcctanyYpqgfvfZW/JUEC+NPq/j9GdnZ
wDmtlf0Ps/1uyC5H1rjok9TT/A+TLVsn54z8U/r82SnPf1i2ZLBWogn6vDHR
9Dxs1z9sLVl/bwhyF869+Bf8w3jDEuVdkPFDqSfYyv8wpsxAyBrk29V3Q3im
5jFnE7WVImPUn8X9eJg8NI9Rl46/uWxM7Mf140If57HHF94qHUY+uVIewHg2
jzHDxk9sQnayrj+gdHEeG1srHlICKXDnWkpu4fF5DOOcCL+EDJnmAxsC5rHU
3m//fJHVb7z31Nw1j1UNVR6XReb+/sV5u8Q8JhV9h54EKBA7vWTuXvYX49Wz
ldy5A/VTEzxXG3L+YvqOhVwKyPcPSPaqpf3FakjhQaztqN/eqRdEOv0Xe/5o
8UIBsoNUSEqJxV+MRzDvDWsb2t9Pv39aGprDfAZIrPNGKB6bpuUO9cxhSpMM
XQfkptzVgI7WOewe767GtcjFCWuW7lfMYcYXNnU9NqTAUA83Obuzc5habcex
b1vRfmS1+edKzmEG47H5QltQ/T3cW8nLP4c1MiRZnQao3g6OLESszmJRUQKn
ryO3tnAk7xyZxdbwRf2lI6dmbq+ceTSLWcV7JfPqU6CCQRXLzH4Wq2spefZW
B9XDMsy4wmQWM7cUi49B5pRrT5TSn8Wely05aCOPcf5ZM7lmFqP+qO9J10bx
+aRsnDk2gzXq9Bjv0qJAkxNZl0fjZjCdikw8QYMCWwYOOJifmsFUba6tKCLb
WqpJ3AuawRQby9qfq1Ogq2T9fQ/7GewEo1N0dBPaz3U/sBbJGYzv24EiLTUK
vLqiMV9QNo2Fnqp5dWI9ej5/1gtyzjTWytT+8U8FnS8fGi56pU5jLp0GlieR
83JdRMSPT2MNWU1NoetQP21yZlPsjmns2jU3kp0Sys/41z4+nUxsr41o+QNZ
CjwwlbKhvpGJRYsmRAohj7h7MKUeMzHLQjHd0LXo85zqn7Odt5iYYLyWvdoa
tF/fCt+EvkzsbLv65UtSFOgo+zRn++QUlrQzs6eLjvb/lPWmv11T2Lvwhisi
yL7412cPnkxhuXW7OneJov3nw9Ejc34Kywnh/l4vTIE5hXZ8i/QpzMR39ewF
ARRfjZ8nH2+dxKS30HYkclLgYjvl5YTsJPbHuE0un4b62xB5yjrqJDbkv9X8
GRXVw4o9ydfbJzBVK12zrxQUv81duaEHJ7ANcf7hHKtkOLIZa9t4ZRw7XxNW
2zhPhvMfvgj6hI1j15bGNMv/kiFn6KLzTfdxLG1uNDNjjgzXVeoNcCmOY3de
T9P3zJChr+aDmeHHfzA48cIAnyDD75o3Ze5+G8N+wCzq1A8ynOl47P3p9RgW
8zJ7tuA7GVKOfSwQKBvDCi02xe4eIkOFKiHNqONj2GzdiTOPB8jQWyvebDfv
GLaqvtnVso8MB7TCj9J1R7ERESNmw3sy7NMmvpD7hZXdi9fmqyHDb2Ik6SvB
v7BB+T+MkGo0n/nqiDTXX5iW8ELfh0o0fp3kxjtKv7APIzMrlx6SIa/pcHo1
NoItJ3d86yokw23OkUFf//3EXrz54P8xiwxzw0vEdQKGsR+Lxym3zpChfw3t
yIDVELbivr/VTZ8M02I0XjWrD2HDZ8zOfdMhw3prd8kK0SHMoKhoa4AWGTKG
iptivnzDvNN3/jq2iQxfC9iuVQj9hn3tFn4UokiG5u3Kd1o0BrGdb+sLFQTJ
8IXODp+ut/2Y0JK8VtswCZauhI7/ovVghyl6KmlpJDgpOdHo0v0RG3iaEbA9
lQR1dAKzG3I/Yu0DERvHrpDgC/8D1tlGHzG72GMuVpdJ8H2HY7HdsW5M29DT
XvIcCTLztH1rv3RiFhl+7wSDSfBIyu8nNP/3WErvIddkGxL8++rboUHye+zd
rviakztJMPpfr/iz2+8wRS/PGD9LErzq3RZ+pOstFjYaFmhlSoLV2qWbu7e/
wVrPi62oGZEg69PholyxFuz6oVnSUTUSjJObumH0CsdIoo4ZPwRI8D6rXuee
C45Ve375sMSHruevvSfQjmE3qWlrJHhJkMTtJXZfoh47tco14sZJgvMd/Ysd
pXXYkNEl8vzyKvju09eysfMRdqdl42jB0CoYl3a6dPpkFma40OBo+xBd/9Fx
tJA3A1tQeXxUt3QV9D6wd+m+cw070ppfoFC0Ci6fvWXimRCHcUgyDfjurQLJ
Py/WLZ7yB41LDRelMlZBtWuD8FPXHBARyQ8koldBupZeUJ1VLXD9vafGwHkV
rOMCEdNyj0FF8dzhWodV8PiLVbTqv8fgrNj7EH27VdB3aW/ajYKnINtjxwaT
natAduBiXRjlBYja5U+JAavAxTwwTnxfA6Aal6Rf3LQKBqaf9LyXaAX045P5
Adyr4HTBRqO7r7sAo6Bwrvj1CnDgWC9CcxoE74b5Q7zdVkCU4vWq0IRB4HBH
ofaeywooMV51/FI/CIz0rxgPO60AMn64rU/8G7j1/pnWUfsV4Lliylt14RtQ
t5pPSrFaAXyRc0n79w6B0FtRU0JGKyA4wvXqC6EfIODrm0QRhRWg6y9x48SJ
EdC91eM7//Qy+Kj71GHg6ghIuHp95dnUMoig7OazKBkB5HODmgGTy+DRnVvn
xL+MgGRn448tf5aB9se1h2uMfwG7edrK9ZFlsNlYGc7w/wYGXk5S+78sg40y
WmNH80fBIm2nRV3rMlD4YL3Dr2McRIuuH3G9vwzq3nsb7xodB0cVd9lY5i8D
l3cnzPQoE4Bkq5u4NW8ZJLTlWdN0J8Dpj0/S5HOXwWTjoltB5gQQ8e96wcpG
r39aGvJz3yR4vXP+d8d19Po83nt+E1PA2WSL45rYZdBo+JOsEzcNdvbtiF0+
tAyizWvjatOmgf6L6PcCyFsc4ni25E4D6wyHUVm/ZfDAb53I9ufTwEKgJMP0
4DJIT/WTt5yeBrNOWg9u7F8GviM/d+zxmgGq1mc3HPRYBtS0kciLerPgpbbG
llTrZWA++utv9885EEs5yBLRQtedJ4JDZuYAb6Qr20tzGbx6MfOLd3UObOIz
v1q6eRnA1OU+Y8m/YP3Ch/3mGstgmwG9vsL6L7j+Lz77vBqKb9yO+KSKv2Bd
htwyXWUZyCpkMExPzwNdAe1Dt2WWAcvDxKCanwXm+vrjZLiXgXJ7svZeaRYI
6+2wPcO1DBxM/1PnVGWBFA/O1D7OZVCsfkTZ05QF+HJkE27SloEH5YYI5QwL
8Cd4bpDjWAbPykb/OP5igckbv87BFTY4s5KaO92wAKq4ukZ75thgKX+QR+vk
EnAU45qT+cEGWwWV/jztXAFXvSU3fHvFBiNnvq4aDayAo73sx4HI6b8yxbCx
FRDZkKY328AGTJx/x2uOVVCgRF+lIReGz6d26q2Cul6nWxsxNhDra9Mfu7kK
sow23A5+zgYsxy0NAlokOGTfv+3TIzawT8iwsTcgQSU+/zZP5ML6mZ7U7SSo
Ye8vPFjNBi5qD8fo1iQoU1vxeqSKDSqoimLSB0nwJe3C9ZkKNjj0hM9fJYME
ucs9+hbK2ODjmkF+sECC4rszch7ns8H33n29XCQyvGWqf1kReSp9IL+Dkwy3
H11tvpLHBrwCA4Y+YmT4fLe+us89NoDLXwLiNpOhXeabrZS7bPDg6+emt35k
SBU0+E/mFhvE5nyK8uhCdWAWj7xxlQ3SPN2sFFBdU71QVDicwgZ3GZ/oY4Oo
DtkeSNdCrkvpKY1EdbQ/Eua1JKN4RX/szeGmwEuGYaM/LrPB3v1duj9Rn5mY
JMj67yIb6Mi3jx8rQ33j9Z8Pzp1gg1dJv7VbqiiwvN89ovQ4Gzj9o5xe85QC
H40NH+2KYIOwdgNaSxPqu3DBr2vC2aA66t7aNQMU+FDwx9StEDbQ6ouwaxbm
gLN9l9/pBbABbnY1XUaCAyZFv44E/mzgUFnyOXQtB9TTvvfH4hAbhF4aOCSz
kQMGXdKZtPNlg0o9q5hQUw5494L2PRNvNticJlMpfYIDZtslplS5s0H9st58
SBQHHJKoP3PdjQ3sAh22vb7AATXylPLCXNkgGMa1hlzlgBlqZtGqzmxQPjn5
ramYA7r27g08ZscG6javREL6OeCz7g0VIWZsoEYNDG+EVPiwwyj9kzobLD7P
fcuyoELx6PZYl01s0Breq6SxiwovZJ6/0r6RDXx/WH7M2k2FEgd76h6vZ4Oc
Vyp6wWFU+N3uw043BTYQPj88L3mfClUSeeVb6WwwsGWNvV0pFb6Y/KhHEWWD
h0znoouVVLhV+3iJgTAbWHs3uk++oMI30VtOp/OzwUWQ97SxhwpLGDbeYjQ2
mF/efyaYiwbXJw5bKP5dAk21mV35AjRYTXXfyz+7BK4f/bCxj06DrVJD1Gnm
EtD8uqPfVJ4GudY2fS4ZXwKBL9Zuk9pKg8ACqPb+WAJfzvQvNwbRoKifzT2Z
ziXQ8M/tvFQ7Dc4/E6gaLFwCFnpV0p8+0mBf6OeYxvwl8CaMryatnwZjOOnM
nNwl8HECG+EbpUGRQDx0260l8PuHqu0KBycUmNkkLXxlCQh3LDJ+bOWEpdmc
8XzHlkCGgGvlXcgJS55+zjpwdAlI21Ts3GvJCc9Wa1qUBy4B5eaDUT0unPCW
WYi2ms8S2PLi3VBLCCdkGjYUVTktAe/inAcPCjjhS8tjZsNaS+DnT5Z54ANO
aGb+Q+SO+hIIUnIeXPcIvd/XGxk2G5ZARA6X6F2cE7ozq65cll8CCemhJ6/1
c8LC+9VTlwSXQOU5E5MTIlzQseLL29jfi2DVY+Q/cJYLXlb/9gamLwJOi/4/
CRe54Gh28YGVlEUgqNOx2nmZC3bQExSrLy+CNQJ1631vcMENeu3S7OhFYNhw
5WRCBRd8lPUPkwpcBBEb9CQ6h7igG9ZUGWm0CMYWLrr5WHDD6nhRh9HeBTAz
ciqozJYbUhw3Gwd3LYCF7qPRc07c0Mln/vHo2wXAXe5eGL+fGy7JHHRsql8A
63zU5ktPccMDUp+28txfAN5vujJmS7nhN8yt4PORBdBzS6EnVogHGpkeiJ75
xwJpAls3ujJ4YBGPl1fdFAs4nHOIWbeWB77etnb1FDqX3/nFbGjeyAMLfjj9
/PyJBZo0v57lsuCBY2HcbTq1LFDTnKWSGMUDK7vng+xDWSB9RujU1VEeeKIu
mGfs2z/gbL0ifauRF46/6a3xqJ4HQZ/judo9+SHpTurm+FNzYNTKbZT3AD+M
zJRc1Q2dAwFP1r219OeHm1ol4aj/HPBLb0ppCEf3cwWe8HGfA952FEZtMj8M
jRmxvqU/B9xfnVW+Xc8P5xwEXujMzwKz0gjjIEUBeK7Im1FwZhY0SpopFakK
QC92xgb18FlgcolOG9YQgFKJdx1fHp4FwLe61ctIAO6rOLVufu8sMJRl2ju6
CMDXtq7Vb8Es0Ew7vG9LvAB85261QYxrFqw94xPJOSYAgw6HR5y+PQOcgl1y
3jDR/Tl0ucyMGZDgY9GQ8k8AmuV90sJTZsCM9UYuCZogvNaT9Fj3/AxolZlJ
Wy8vCH8JZmkXH5oBES/Pl1q5CcIfB0yUMZ0ZUFoV/p7fSxA6nTcZu6E+AwYL
/JgdBwVhg+2l6DPrZ4B1yk793ccEIbdzjIyfzAyQ3y/yKjBZEA6Jpjm2csyA
t6R7fYmvBOH7KPNrzZ+mAelvGtuuTRBWj60L39OJ+pDRWDl6hyAMrNeTYL+d
BrmdAX7ZXwWhm+XmdO+GaXAiT3O6jIXeb9f1D7UPpoGiGc79XkMIbjqaHZ2E
+prTlwYNhLKF4PHPS5vywTTQVDvSs/+eEFS+ky/402ga/G5nhVUWCcH7AyQF
zS3TwIMhWu5YIwRnL6wUD2lOgy0FZsrp74XgD6jwt1JxGkQOuSTwk4RhfEtC
9F+uaeCmI/OfLocwXHOv/W4TdRr1I0PrvDiFoSPkVblNngZjqsGND/mFYUaq
90bfJSbwDL20YiclDAUUC5LdppjAcPVZxDVtYVj+1NDmaS8TMBzPNT7TE4Zq
JqYKXJ+YYCbPQvT7FmH4xk3glFc3E5RadFdoA2Fo5qVwVL6dCaRSxse6bYTh
xFBW73IjE7DWyB1g+AlDbb8vTTxVTPAx+GfFjgBhWIFNPW8rZ4JKvGzl0GFh
eHXwlGXqAyYI8N1y+8kxYRhyWHRIs5gJessc//OIFob7Wocu1t9lgieGsbuy
M4VhptPpjpWrTBD8oX8bV7Yw5Ol0uLRwhQlUfHU2hecIQ0lB8GsxiQnSr3zn
tSkQhoHcE54iCUwQ+g22LlYLw/PGcopJ55hgY/yyiWe7MOzkWUfOD2OCIWlX
7eZOYWjUf0iKdIwJsioeKGj3oHg8fNjiE8IEXH17SLxfhKFtiVzBliNMMKxW
9/LZqDCMrWy5p3yICXI6T2yRoonAvc6b5qc8mcD1UPv6OG4RmNK2h+fubibg
X1onMc0nAkUPJTx38mCCSOWev62iIrDJcU9jiysTeJzUeXRKXgRe+xTTM+LA
BKJrmeq9RiLwQ89F0QlLJmirslxrBkSg06Wr2YMWTHDO4i5/pYkIFGeYjPeY
M8FUiN2fSztF4C59zUfvTZng3asHxQbuIvDB1PbY34AJ4gIClTLDRGBSmR9H
wxYm2Jv/QWb2uAgU5nm/f9KACbQH9MTsT4vAmNsulbLIA84UGtc5EWgUu5cz
QY8JtoDskRNXRGBLZ/ypKG0mGBd/X+JWLALlDjO8hzcxwSsHnbzqMhH4I+hd
1jbkm0k3bwlWiECLIBPdTDUmsCAfSmquFYF/fArDnDcyQe74yhH9RhFIHwDq
v9YzgUujpiZjQATu0Pf4HaGE1mflhmrYkAjcItxdNKXIBOSty/Ltw+h+Zpvj
EeTy8jaR+D8iqB8ysj6swATct3xm/7JE4P2PFuIxckzwPDT9cQ9dFGLd9Jss
GSZIK1ss15IQhbacERxXkQNGvIuuSIvCp0u//6ogi+1VzzJXEIUxRUpee6RR
flk2n67VEIUchW53eySZQFGWtS1jpyicLqWf42MwQV1lWdgTW1H4H39S6ktx
JnA03V/cZy8Kb75dqQxFPhfQTJd1E4W7aiPon8WYYLA6fazQRxSa3rBjP6Uz
wW1LraynkaIwe3NdyH0RJtD9PPz+c7QoXNkq9ssP+e2RLI7l86Kwf+jdVlXk
xWurwcYJotDT9I5fhTAT7P7y3vxNuigcyyuObxFC+/VY0Gz/Q1H4tkQqeY0g
ig+H7IaVSlF4tzvmyJgAE5jf6NwnXyMK5Rknl58iRzzf8sa3ThTGrklb74Hc
TeO6N9EsCnMU4vbk8DNB6q18u9VBUbgpv8DZio8JVNXdYxV+iEI1Wd3N8sg4
xltnOiIKvR7lZ7F4Uf4NH1uXMC4Kxw8eEyhDttsM2cILopChBa0ZyHxNX0oU
Renwn/D3c1QeJoi+qXAuQZwO/2hvrRziZgJm8CG3SUk6fJJq5ochf5JiUurk
6DCCftUjCjkvhGOvozodHvDdpMHmYgJxcyvtJ5p0+PjCBtevyAnSV7jX6tJh
jGXjTD1y8GtG7W9DOlwn0pR4EdlQZqPgOSs6dKRsXBFBfsgMHv5pQ4fAmL90
npMJ5Jsf1dnY06HFRnmsH5nz2HZ/CTd0PfW2bBFyV7MDXn6QDpNGAhNMkIPC
ToZ9jaZDvc13XifSmOCr5Qsr0wt02JFd5nIc2WEtWa4kjg41fAL0vZH1WxPf
RiTT4eaMlXF9ZIpsjjL/LTpsEZSh/aYywfHZ74vH7tChiCSLqwf5d+v6zv9y
6fDZvTUur5Dbw6vO5hfRoVd1f+Md5JttTZ8Ma+mQUy7ihzsy/12eh7lP6bA+
rkrUEjk6wu4i5ws63OA7cEEf2Veud3PXKzo0slVWZCBrHv+TENhBh1k1y8a9
HEzQKi9qlPWHDg2GdwB/ZPau+3ZNk3SYeblp0hNZM1LfhzlNh/2/G97YIWf1
eF62YtHhjHMhzQA5MDH/PxZVDHoeVzzBg8w7pxuxW1YMupjrNtRSmGCHQsul
OAUxaDb6a7oMOcxud3aVshh0DBayyEP+XHz2FY+aGPShvXS7ilzm1SxcZyAG
C4N5+A8j27a4P5R2FIPJAkX7VZHPzY3iFi5iMMfg5FV55BqFqI9h7mKQoz+h
XxJ5TVTu0hsvMaiz83MzD/KE5ujOyCAxOP8+YHCczAQpt86M9F8Ug6dUtzY/
QX7Vwr/IdUkMUkzdr1Qhz8/lCOgmikHyT1ZQGfJ++0bd5FQxGFRzIeAusiaV
/+K2O2Kw14Lum4DcefSO3J3HYrBzR4vMPmRl4x3bnj0Tg5IvVeFu5FNigx49
L8TgAa7W4y7Iss/l0wQaxeDlU+/oNshHuO9Toz+geBSHiW1F5sovHd33WwxG
xK3OSyB7nrDhjPwjBmdM94mJIZfvHFfMnBSDoeYJQBjZham+98Mciq9MZD03
ct72qnZAFodeJQ92L5KYYHvvk0fy0uIw8HX/10Hk1DKPjm1rxeH2m4dffUEe
jl4Y95AXh73bqdV9yInrjFSuqYhDt6lHVd3IvWH1WWQdcWh9fUSjFTlc4PXZ
7zboOj+d/Ai5+ZvfrRU7cZgdy4qtRJau4Xwi7SQOxcOqRMqRcU8rppOHOBTp
kDcvQRYsfuvT6CsOFS7kC+cil5h0Wd4/Kw7PvFiVv0qM50GlUc+Lw5LZ8IVk
ZM4Q/VcHY8VhzHvdz4nIvtm3tiklicNoybU18ciycz5aeVni0NR+fXM08i7e
jEnybXF4MOj21yjkKPmWsgN3xaFB9mH2GeQ+WzUVhUJx2HisyP4kcnrBrHTu
I3E43HljZyhy4/N1vauPxSElqD8rGHmm0z1jf504/KaTP3kE2X7luZBcgzhU
DfZ4GIjM6x5LzWkXh/ex6oiDyDHc4pPZo+JQUVFawgO5XNaybGlcHO4ovNno
hvxF93TAHqY4XHXSO+6KbHjg63fpf2h+T8N+OSHPPSv47yaVAQ2o0zQ7ZKWO
/9IXuBgwg23YZ4vsNMLjtJuPAS/U8FXZIFeIBr+TFGXAlN9LR3ciBx3Wb8iU
Y8CEaCBjjnzzfED0P0UG/PHgp7AZcmvmLSN3FQb0Aim8psjrmlZqGeoMmEkt
4TFG/rampTTDkAGN+Q7qbUd2bXdPv+7KgIXCqfr6yGbb/kt55sGAFRyR4XrI
uqVulwf3MGD+Z6VHushi8a7Raj4MSP95yVAH+eN254DGYAYM/XUlQBPZ+aHd
ttlLDJimlr9VDdlEpl1fKokBnYQlcjYia1/epQVSGPBOXh2VsKifrUpSOgOW
nzjWq4rctcZaWOkeA16Ob81SQXZMNh92qmPAOKG2E4rIcLFp4NRLBpzf1Lio
gKwZYNaXgzPgyauR5wgLm5m2jzUzoKyy4DV55I4l+PRCNwN2HBFuliXW9/C2
5OpxBjS3ij4jg7yj73l87xQaf2e2BGENS6PzKzMMyJRf81iayGclwxPWCww4
dUDvnxRy+2cD7+80CdgRt+OyJJGP1jq6onISkF5X8FscWfmsz58MRQlYeLcm
lfBixbU8KRUJSIpRNiRcLM4UVlCXgN9lRa6JIVOHHkxsNpKAe90S7OjI/fQv
9x/tkIArX7jJhKst+PYamEhAq3C8RhR5/4PANzt2SkDcu0GOcN1JlaJd7hLw
Tng8hwjytVLXfZ2eErBc1ggTRg74Givuuk8C6o6SowiLm/64uNdPAqq8rGEJ
IYcK5nofDpeAvYZGK4LIKgVS0pevSsC7e/brCyAv/2fVyX9dAvqsdyMT/sh7
KiH1hgTc1KPwnh/5fOin+cw7EvBc4kZ/wl+MrncXlklAVdWi+3zIj4JfJW6s
kIBXQ8aOE068N21cXi0BuRxHLQlv4XKorH0mAUU2Ck7yIl/v4r/S1CIB4x7f
NyEcRNtmZvVWAjovRUgRhlsOL71tl4DP08aYPMiTd9oCu3skYJTf83uErQPj
Lb7/kIDbrjzkJaxwu3bZ75cEtBb0GeFGZrUP14yOScCXoPgV4QJdU6XpaQk4
efNbFOEo/7DPEX8l4Fnbdk/CTrfuXWOxJGD7K7OthDe877CKYkvAif+MJQn/
///DS8JzIY3/uJD/D5HYMcA=
     "]]}},
  Axes->True,
  AxesOrigin->{0, 1.},
  Method->{},
  PlotRange->{{-4., 6.}, {1.00000759871088, 2.28587994248648}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.5707970045507874`*^9, 3.5708073499755116`*^9, 
  3.5708074507132735`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"res", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"lom", ",", "Z1", ",", "Z2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"lom", ",", 
       RowBox[{"-", "4"}], ",", "6", ",", "0.1"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.48224695415106*^9, 3.4822470058780184`*^9}, 
   3.482247616006916*^9, 3.482249406678336*^9, {3.4899180741550074`*^9, 
   3.489918075995113*^9}, 3.4899212882048407`*^9, {3.4899214747325096`*^9, 
   3.4899214784287205`*^9}, {3.4899218207332993`*^9, 3.489921838733329*^9}, {
   3.4899218689890594`*^9, 3.4899218743173647`*^9}, {3.5214771395024776`*^9, 
   3.521477155727406*^9}, {3.5218885571592216`*^9, 3.5218885778004026`*^9}, {
   3.521888616026589*^9, 3.5218886178476934`*^9}, 3.52188931853577*^9, 
   3.521889982983774*^9, 3.5219051233047514`*^9, {3.5219114029689274`*^9, 
   3.521911407609193*^9}, 3.521911476249119*^9, {3.570535356419838*^9, 
   3.570535388915696*^9}, 3.5705394635877542`*^9, {3.57053949726768*^9, 
   3.57053949778371*^9}, {3.570539586787801*^9, 3.570539603699768*^9}, 
   3.5705397446258287`*^9, 3.5707970178545485`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<FLtrans-Mat.txt\>\"", ",", "res", ",", "\"\<Table\>\""}], 
  "]"}]], "Input",
 CellChangeTimes->{
  3.4822493502621098`*^9, 3.482249404502212*^9, {3.5214771654379616`*^9, 
   3.521477166414017*^9}, {3.5214772797595005`*^9, 3.521477280894565*^9}, {
   3.570535395572077*^9, 3.5705353973291774`*^9}, {3.570539502739993*^9, 
   3.570539506052183*^9}, 3.57053956107633*^9, {3.570539655171712*^9, 
   3.570539663507189*^9}, 3.5705397519122453`*^9, {3.570555063732031*^9, 
   3.5705550730595646`*^9}, {3.5707970342074833`*^9, 3.570797034910524*^9}, {
   3.570807404896653*^9, 3.5708074258878536`*^9}}],

Cell[BoxData["\<\"FLtrans-Mat.txt\"\>"], "Output",
 CellChangeTimes->{
  3.4822470588200464`*^9, 3.4822494180059843`*^9, 3.4899206141082845`*^9, 
   3.489921297854392*^9, 3.489921507021356*^9, 3.4899219563290553`*^9, 
   3.4899231604799285`*^9, 3.4899232116098533`*^9, {3.489923243844697*^9, 
   3.4899234299013386`*^9}, 3.489923576874745*^9, 3.489924137500811*^9, 
   3.4899242266079073`*^9, {3.489924259050763*^9, 3.4899242800389633`*^9}, 
   3.48992440848431*^9, 3.489924456798074*^9, 3.4899245311753283`*^9, 
   3.489924572106669*^9, 3.4899246228165693`*^9, 3.521477172796382*^9, 
   3.521477284913795*^9, 3.5214822422093363`*^9, 3.521888435924288*^9, {
   3.521888586032873*^9, 3.521888593822319*^9}, 3.5218886267072*^9, 
   3.5218891977378607`*^9, 3.5218893274762816`*^9, 3.521889636575961*^9, 
   3.521889993244361*^9, 3.52189013240032*^9, 3.52189053118713*^9, 
   3.521890635130075*^9, 3.521890901785327*^9, 3.521892393817666*^9, 
   3.5218924793715596`*^9, 3.521892631782277*^9, 3.5218932292434497`*^9, 
   3.521902174817107*^9, 3.521904361425174*^9, {3.521905116755377*^9, 
   3.521905129597111*^9}, 3.5219114182288003`*^9, 3.5705354057616596`*^9, 
   3.570539344568947*^9, 3.570539511388488*^9, 3.570539566442637*^9, 
   3.57053967402779*^9, 3.570539755160431*^9, 3.570539785664176*^9, 
   3.5705550796219397`*^9, 3.5705551278827004`*^9, 3.5705553211777563`*^9, 
   3.5705555661347675`*^9, 3.5705571992251744`*^9, 3.5705572361762877`*^9, 
   3.5705572718723297`*^9, 3.5705579554434276`*^9, {3.570558094625388*^9, 
   3.5705581336466208`*^9}, 3.570797038781745*^9, 3.57080735082156*^9, {
   3.5708074135581484`*^9, 3.5708074508432813`*^9}}]
}, Open  ]],

Cell[BoxData["\[AliasDelimiter]"], "Input",
 CellChangeTimes->{3.5708074561225834`*^9}]
}, Open  ]]
},
WindowSize->{1902, 918},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{32000, 32000},
PrintingOptions->{"Magnification"->1.,
"PaperOrientation"->"Portrait",
"PaperSize"->{600, 780}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
Magnification->1.6000001430511475`,
FrontEndVersion->"9.0 for Microsoft Windows (64-bit) (November 20, 2012)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 801, 15, 186, "Title"],
Cell[CellGroupData[{
Cell[1393, 41, 589, 10, 164, "Input"],
Cell[1985, 53, 2050, 30, 47, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4072, 88, 1844, 29, 54, "Input"],
Cell[5919, 119, 566, 12, 75, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6522, 136, 678, 15, 47, "Input"],
Cell[7203, 153, 899, 20, 95, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8139, 178, 146, 3, 47, "Input"],
Cell[8288, 183, 789, 19, 95, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9114, 207, 308, 9, 47, "Input"],
Cell[9425, 218, 718, 20, 126, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10180, 243, 87, 1, 47, "Input"],
Cell[10270, 246, 109, 1, 47, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10416, 252, 147, 3, 47, "Input"],
Cell[10566, 257, 1040, 26, 201, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11643, 288, 147, 3, 75, "Input"],
Cell[11793, 293, 1041, 26, 201, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12871, 324, 365, 9, 123, "Input"],
Cell[13239, 335, 1893, 52, 220, "Output"],
Cell[15135, 389, 2063, 55, 251, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17235, 449, 152, 3, 75, "Input"],
Cell[17390, 454, 413, 7, 78, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17840, 466, 1182, 25, 448, "Input"],
Cell[19025, 493, 514, 7, 75, "Output"],
Cell[19542, 502, 514, 7, 75, "Output"],
Cell[20059, 511, 537, 8, 105, "Output"],
Cell[20599, 521, 538, 8, 105, "Output"],
Cell[21140, 531, 538, 8, 105, "Output"],
Cell[21681, 541, 517, 7, 75, "Output"],
Cell[22201, 550, 517, 7, 75, "Output"],
Cell[22721, 559, 517, 7, 75, "Output"],
Cell[23241, 568, 518, 7, 75, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[23796, 580, 1445, 24, 75, "Input"],
Cell[25244, 606, 15995, 268, 305, "Output"]
}, Open  ]],
Cell[41254, 877, 96, 1, 75, "Input"],
Cell[CellGroupData[{
Cell[41375, 882, 405, 11, 75, "Input"],
Cell[41783, 895, 8520, 147, 432, "Output"]
}, Open  ]],
Cell[50318, 1045, 94, 1, 75, "Input"],
Cell[CellGroupData[{
Cell[50437, 1050, 395, 8, 75, "Input"],
Cell[50835, 1060, 2220, 59, 350, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[53092, 1124, 936, 17, 75, "Input"],
Cell[54031, 1143, 16936, 285, 1144, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[71004, 1433, 293, 8, 75, "Input"],
Cell[71300, 1443, 15257, 257, 252, "Output"]
}, Open  ]],
Cell[86572, 1703, 1163, 22, 75, "Input"],
Cell[CellGroupData[{
Cell[87760, 1729, 649, 11, 75, "Input"],
Cell[88412, 1742, 1650, 23, 75, "Output"]
}, Open  ]],
Cell[90077, 1768, 87, 1, 75, "Input"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
